//=============================================================================
// DualattackTimes.js
//=============================================================================

/*:ja
 * @plugindesc ver1.01 装備している武器数が１を超えた分だけ
 * 攻撃追加回数に加算します。
 * @author まっつＵＰ
 *
 * @help
 * 
 * RPGで笑顔を・・・
 * 
 * このヘルプとパラメータの説明をよくお読みになってからお使いください。
 * 
 * パラメータとプラグインコマンドともにありません。
 * 
 * アクターの通常攻撃において
 * 攻撃追加回数または連続回数の増加によりターゲットが複数になるとき
 * 武器１のアニメーション→武器２のアニメーション→武器３・・・と
 * 表示するアニメーションを切り替えるよう仕様変更しています。
 * （ターゲットの数よりも装備している武器が少ないときは
 * 　武器１のアニメーションから切り替えなおします。）
 * 
 * YEP_BattleEngineCore.jsより下に配置することで
 * アクターの通常攻撃の
 * アニメーションとダメージの挙動を改善します。
 * また、攻撃中想定の武器に持ち替えてモーションさせます。
 * 
 * ver1.01 BEC競合対策
 *  
 * 利用規約(2019/9/6変更)：
 * この作品は マテリアル・コモンズ・ブルー・ライセンスの下に提供されています。
 * https://materialcommons.tk/mtcm-b-summary/
 * クレジット表示：まっつＵＰ
 *
 */

var Imported = Imported || {};
Imported.DualattackTimes = true;

(function() {
    
//var parameters = PluginManager.parameters('DualattackTimes');

if(Imported.YEP_BattleEngineCore){

var _BattleManager_startAction = BattleManager.startAction;
BattleManager.startAction = function() {
    this._DTtimes = 0;
    _BattleManager_startAction.call(this);
};

Game_Actor.prototype.performAttack = function() {
    var weapons = this.weapons();
    var len = weapons.length;
    var num = BattleManager._DTtimes % len;
    var wtypeId = weapons[num] ? weapons[num].wtypeId : 0;
    var attackMotion = $dataSystem.attackMotions[wtypeId];
    if (attackMotion) {
        if (attackMotion.type === 0) {
            this.forceMotion('thrust');
        } else if (attackMotion.type === 1) {
            this.forceMotion('swing');
        } else if (attackMotion.type === 2) {
            this.forceMotion('missile');
        }
        this.startWeaponAnimation(attackMotion.weaponImageId);
    }
};

}

//オーバーライド
Game_Actor.prototype.attackTimesAdd = function() {
    var sum = this.traitsSumAll(Game_BattlerBase.TRAIT_ATTACK_TIMES);
    var sum2 = Math.max(this.weapons().length - 1, 0);
    return Math.max(sum + sum2, 0);
};

Game_Actor.prototype.DTattackAnimationId = function(times) {
    if(this.hasNoWeapons()) return this.bareHandsAnimationId();
    var weapons = this.weapons();
    var len = weapons.length;
    var num = times % len;
    return weapons[num] ? weapons[num].animationId : 0;
};

Window_BattleLog.prototype.showActorAttackAnimation = function(subject, targets) {
    this.DTshowAnimation(targets, subject, false);
};

Window_BattleLog.prototype.DTshowAnimation = function(targets, subject, mirror) {
    var id = 0;
    var delay = 1;
    var nextDelay = this.animationNextDelay();
    for(var i = 0; i < targets.length; i++){
        if(!Imported.YEP_BattleEngineCore){
            id = subject.DTattackAnimationId(i);
        }else{
            id = subject.DTattackAnimationId(BattleManager._DTtimes);
            BattleManager._DTtimes++;
        }
        if(!id) continue;
        targets[i].startAnimation(id, mirror, delay);
        delay += nextDelay;
    }
};
 
})();
